/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatEoE_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat EoE
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      2        25.06.2008  sb
        added support for different instance number on EoE task

      1        04.07.2005  SB       1.000
        Created

**************************************************************************************/
#ifndef __ECAT_EOE_FUNCTIONLIST_H
#define __ECAT_EOE_FUNCTIONLIST_H


/** version of task startup parameter */
#define ECAT_EOE_STARTUP_PARAM_VERSION (1)

/***************************************************************************************/
/* Ecat EoE function list, prototyes */

TLR_RESULT  TaskExit_EcatEoE (void* pvRsc);

TLR_RESULT  TaskLeave_EcatEoE(void* pvRsc,
                              void* pvLve);

void  TaskEnter_EcatEoE(void* pvInit);

typedef UINT8 ECAT_EOE_MAC_ADDR_T[6];

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
typedef struct ECAT_EOE_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** Edd Config data */
  struct
  {
    /** start edd device */
    TLR_BOOLEAN32                   fStartEddDevice;
    /** initialize FoE stack with internal volume handler */
    ECAT_EOE_MAC_ADDR_T             abMacAddress;
    /** instance of mac address to be used from sec mem (0 ... 3 , otherwise parameter is ignored) */
    TLR_UINT32                      ulInstanceMacAddress;
    /** edd idn */
    TLR_STR                         abEddIdn[16];
    /** edd instance number */
    TLR_UINT                        uEddInstance;
    /** resource control */
    TLR_BOOLEAN32                   fRsrcControl;
  } tEddConfig;
  /** config for Esc mbx linkage */
  TLR_UINT32                        ulInstanceOfEscStackTasks;
} ECAT_EOE_STARTUPPARAMETER_T;


/***************************************************************************************/
#endif /* #ifndef __ECAT_EOE_FUNCTIONLIST_H */
